/*********************************************************************
 *
 *  Logfiles.c
 *  Module for Power Monitor Logfile Logic
 *   
 *
 *********************************************************************
 * FileName:        logfiles.c
 * Dependencies:    fileio.c
 * Processor:       PIC24F
 * Compiler:        Microchip C30 v3.12 or higher
 * Company:         Kunzig Enterprises Inc.
 
*********************************************************************
 * Function:        CreateNewBillingMonthLogfile
 *
 * PreCondition:    MACGetHeader() == TRUE
 *
 * Input:			Month and Year in integer form year == YYYY i.e 2011 , month = 1 for Jan 2 for Feb etc
 *                  
 * Output:          New Logfile created on the thumb drive with the name of Logfile-YYYY-MMM of the next month and the new logfile name will be saved in the Power readings structure
 *                  
 * Side Effects:    If the same file already exists it will be deleted
 *
 * Note:            
 *
 ********************************************************************/
#include "GenericTypeDefs.h"
extern void uitoa(WORD, BYTE* );


void CreateNewBillingMonthLogfile(int year, int month)
{	
	char yearStr[10];
	uitoa((WORD)yearStr, (BYTE*)yearStr);
}
